-- Reduce some varchar(255) to varchar(191) for consistency with new installations using utf8mb4 collation
ALTER TABLE `redcap_auth` CHANGE `username` `username` varchar(191) COLLATE utf8_unicode_ci NOT NULL;
ALTER TABLE `redcap_auth` CHANGE `password_reset_key` `password_reset_key` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `redcap_config` CHANGE `field_name` `field_name` varchar(191) COLLATE utf8_unicode_ci NOT NULL DEFAULT '';
ALTER TABLE `redcap_ehr_access_tokens` CHANGE `patient` `patient` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `redcap_ehr_access_tokens` CHANGE `mrn` `mrn` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'If different from patient id';
ALTER TABLE `redcap_ehr_user_map` CHANGE `ehr_username` `ehr_username` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `redcap_external_links_users` CHANGE `username` `username` varchar(191) COLLATE utf8_unicode_ci NOT NULL DEFAULT '';
ALTER TABLE `redcap_external_modules` CHANGE `directory_prefix` `directory_prefix` varchar(191) COLLATE utf8_unicode_ci NOT NULL;
ALTER TABLE `redcap_external_modules_downloads` CHANGE `module_name` `module_name` varchar(191) COLLATE utf8_unicode_ci NOT NULL;
ALTER TABLE `redcap_instrument_zip` CHANGE `instrument_id` `instrument_id` varchar(191) COLLATE utf8_unicode_ci NOT NULL DEFAULT '';
ALTER TABLE `redcap_instrument_zip_authors` CHANGE `author_name` `author_name` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `redcap_instrument_zip_origins` CHANGE `server_name` `server_name` varchar(191) COLLATE utf8_unicode_ci NOT NULL DEFAULT '';
ALTER TABLE `redcap_locking_data` CHANGE `username` `username` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `redcap_reports_access_users` CHANGE `username` `username` varchar(191) COLLATE utf8_unicode_ci NOT NULL DEFAULT '';
ALTER TABLE `redcap_surveys_erase_twilio_log` CHANGE `sid` `sid` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `redcap_surveys_response_users` CHANGE `username` `username` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `redcap_user_information` CHANGE `username` `username` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL;
ALTER TABLE `redcap_user_rights` CHANGE `username` `username` varchar(191) COLLATE utf8_unicode_ci NOT NULL;
ALTER TABLE `redcap_user_whitelist` CHANGE `username` `username` varchar(191) COLLATE utf8_unicode_ci NOT NULL DEFAULT '';
ALTER TABLE `redcap_validation_types` CHANGE `validation_name` `validation_name` varchar(191) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Unique name for Data Dictionary';
ALTER TABLE `redcap_ddp_records_data` DROP INDEX `map_id_mr_id_timestamp_value`;
ALTER TABLE `redcap_ddp_records_data` ADD KEY `map_id_mr_id_timestamp_value` (`map_id`,`mr_id`,`source_timestamp`,`source_value2`(128));
ALTER TABLE `redcap_docs` DROP INDEX `project_id_comment`;
ALTER TABLE `redcap_docs` ADD KEY `project_id_comment` (`project_id`,`docs_comment`(190));
ALTER TABLE `redcap_ehr_access_tokens` DROP INDEX `access_token`;
ALTER TABLE `redcap_ehr_access_tokens` ADD KEY `access_token` (`access_token`(190));
ALTER TABLE `redcap_external_module_settings` DROP INDEX `value`;
ALTER TABLE `redcap_external_module_settings` ADD KEY `value` (`value`(190));
ALTER TABLE `redcap_messages` DROP INDEX `message_body`;
ALTER TABLE `redcap_messages` ADD KEY `message_body` (`message_body`(190));
ALTER TABLE `redcap_projects` DROP INDEX `app_title`;
ALTER TABLE `redcap_projects` ADD KEY `app_title` (`app_title`(190));
ALTER TABLE `redcap_projects` DROP INDEX `project_note`;
ALTER TABLE `redcap_projects` ADD KEY `project_note` (`project_note`(190));
ALTER TABLE `redcap_user_information` DROP INDEX `user_comments`;
ALTER TABLE `redcap_user_information` ADD KEY `user_comments` (`user_comments`(190));
-- Remove DDP on FHIR early adopter
delete from redcap_config where field_name = 'fhir_ddp_expose';